'use strict'


const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid = use('App/Class/Grid');
const Form = use('App/Class/Form');
const AdminMenu = use('App/Models/admin/Menu');
const __ = use('App/Class/Fa');


class AdminMenuController extends AdminController {

    constructor() {
        super();
        this.title = "مدیریت مدیران";

    }

    async grid({ request, view }) {

        var grid = new Grid(AdminMenu, request.originalUrl());

        grid.column('id', __('Id'));
        grid.column('title', __('Title'));
        grid.column('uri', __('Uri'));
        grid.column('icon', __('Icon')).display(function (val) {
            return '<i class="fa ' + val + '"></i>'
        });
        grid.column('order', __('Order'));
        grid.column('parent_id', __('ParentId'));
        grid.column('permission', __('Permission'));
        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();
        return grid.render();
    }


    async form({ request, view }, id = null) {
        var form = new Form(AdminMenu);
        if (id != null) {
            await form.edit(id);
        }

        form.text('title', __('Title'));
        form.icon('icon', __('icon'));
        form.number('order', __('order'));
        var s = await AdminMenu.query().where('parent_id','=','0').fetch();

        s=s.toJSON();

        var ss = [{ id: "0", title: "اصلی" }];
        s.forEach(function (e) {
            ss.push({ id: e.id, title: e.title });
        })





        form.select('parent_id', __('parent_id')).options(ss);
        form.text('permission', __('permission'));
        form.text('uri', 'Uri');



        return form.render();
    }


    async update({ request, view, params, session }) {

        try {
            var record = await AdminMenu.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }



        return this.show({ request, view, params, session });

    }


    async store({ request, view, session,response }) {

        try {
            var record = await AdminMenu.query().insert({...request.all() });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }


        return response.redirect(request.originalUrl().replace('/create',''));

    }


    async remove({ request, view, session, params , response }) {

        try {
            var record = await AdminMenu.query().where('id', '=', params.id).delete();
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }
        // return request.originalUrl()+'/../..';
        
      
        return response.redirect(request.originalUrl()+'/../../.');

    }

}

module.exports = AdminMenuController