
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const AdminRolePermission = use('App/Models/AdminRolePermission');
const __ = use('App/Class/Fa');
const AdminRole = use('App/Models/AdminRole');
const AdminPermission = use('App/Models/AdminPermission');
class AdminRolePermissionController extends AdminController {    

      constructor(){
        super();
        this.title="چارچوب - دسترسی";
      }


      async grid({request ,view}){
        var grid=  new Grid(AdminRolePermission,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('role_id', __('role_id'));
        grid.column('permision_id', __('permision_id'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(AdminRolePermission);
        if (id != null) {
            await form.edit(id);
        }


                var roles = await AdminRole.query().fetch();

                roles=roles.toJSON();
                var listroles=[];
                var listpermissions=[];

                var permissions = await AdminPermission.query().fetch();
                permissions=permissions.toJSON();


                roles.forEach(function (e) {
                  listroles.push({ id: e.id, title: e.slug });
                })
                
                

                permissions.forEach(function (e) {
                  listpermissions.push({ id: e.id, title: e.slug });
                })

                form.select('role_id', __('role_id')).options(listroles);
                form.select('permision_id', __('permision_id')).options(listpermissions);

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await AdminRolePermission.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        try {
            var record = await AdminRolePermission.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await AdminRolePermission.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = AdminRolePermissionController



