
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Banner = use('App/Models/Banner');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
const sharp = require('sharp');
class BannerController extends AdminController {    

      constructor(){
        super();
        this.title="اسلایدر";
      }


      async grid({request ,view}){
        var grid=  new Grid(Banner,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('image', __('image')).image();
        grid.column('type', __('type'));
        grid.column('type_id', __('type_id'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Banner);
        if (id != null) {
            await form.edit(id);
        }
                form.image('image', __('image')+'754*426');
        form.select('type', __('type')).options([{ id: "link", title: "لینک" }]);
        form.text('type_id', __('لینک'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        const avatar =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/banners/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){

          // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\banners\\'+fileName);
            await sharp(avatar.tmpPath).resize(754,426, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\banners\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
          }else{

            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/banners/'+fileName);
            await sharp(avatar.tmpPath).resize(754,426, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/banners/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
         
          }
  
          }else{
             var fileavatar=null;
          }

        try {
          if(avatar!=null){
            var record = await Banner.query().where('id', '=', params.id).update({...request.all(),image:fileavatar, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
          }else{
            var record = await Banner.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
          }
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {
        const avatar =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/banners/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){

            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\banners\\'+fileName);
              await sharp(avatar.tmpPath).resize(754,426, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\banners\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
            }else{
  
              // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/banners/'+fileName);
              await sharp(avatar.tmpPath).resize(754,426, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/banners/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
           
            }
  
          }else{
             var fileavatar=null;
          }

        try {
            var record = await Banner.query().insert({...request.all(),image:fileavatar, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Banner.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = BannerController



