
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Category = use('App/Models/Shop/Category');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
const sharp = require('sharp');
class CategoryController extends AdminController {    

      constructor(){
        super();
        this.title="دسته بندی";
      }


      async grid({request ,view}){
        var grid=  new Grid(Category,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('title', __('title'));
        grid.column('image', __('image')).image();

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Category);
        if (id != null) {
            await form.edit(id);
        }
        form.text('title', __('title'));
        form.image('image', __('image')+'186*186');

        return form.render();
      }


      async update({ request, view, params, session }) {

        const avatar =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/shop/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){

            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\banners\\'+fileName);
              await sharp(avatar.tmpPath).resize(186,186, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\shop\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
            }else{
  
              // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/banners/'+fileName);
              await sharp(avatar.tmpPath).resize(186,186, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/shop/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
           
            }
  
          }else{
             var fileavatar=null;
          }

        try {
          if(avatar!=null){

            var record = await Category.query().where('id', '=', params.id).update({...request.all(),image:fileavatar, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
          }else{
            var record = await Category.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
         
          }
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })

        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        const avatar =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/shop/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){

            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\banners\\'+fileName);
              await sharp(avatar.tmpPath).resize(186,186, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\shop\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
            }else{
  
              // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/banners/'+fileName);
              await sharp(avatar.tmpPath).resize(186,186, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/shop/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
           
            }
  
          }else{
             var fileavatar=null;
          }

        try {
            var record = await Category.query().insert({...request.all(),image:fileavatar, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Category.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = CategoryController



