
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Drugstore = use('App/Models/Drugstore');
const Therapist = use('App/Models/Therapist');
const __ = use('App/Class/Fa');
const sha1 = require('js-sha1');

const Helpers = use('Helpers')
const fs = require('fs');

class DrugstoreController extends AdminController {    

      constructor(){
        super();
        this.title="داروخانه";
      }


      async grid({request ,view}){
        var grid=  new Grid(Drugstore,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('therapist_id', __('therapist_id'));
        grid.column('license_number', __('license_number'));
        grid.column('tel', __('tel'));
        grid.column('bank', __('bank'));
        grid.column('account_number', __('account_number'));
        grid.column('card_number', __('card_number'));
        grid.column('sheba_number', __('sheba_number'));
        grid.column('avatar', __('avatar'));
        grid.column('address', __('address'));
        grid.column('economic_code', __('economic_code'));
        grid.column('contract_number', __('contract_number'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        grid.disableDelete();
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Drugstore);
        if (id != null) {
            await form.edit(id);
        }
        if (id == null) {
          form.text('name', __('عنوان'));
          form.text('lastname', __('بامدیریت'));
        }
                form.text('therapist_id', __('therapist_id'));
        form.text('license_number', __('license_number'));
        form.text('tel', __('tel'));
        form.text('mobile', __('mobile'));
        form.text('bank', __('bank'));
        form.text('account_number', __('account_number'));
        form.text('card_number', __('card_number'));
        form.text('sheba_number', __('sheba_number'));
        form.image('avatar', __('avatar'));
        form.textarea('address', __('address'));
        form.text('economic_code', __('economic_code'));
        form.text('contract_number', __('contract_number'));

        form.password('password',__('password'));

        form.map(__('map'));


        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await Drugstore.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        
        const avatar =  request.file('avatar', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        })
        var fileName = `${new Date().getTime()}.${avatar.extname}`
        var fileavatar='/uploads/nurses/'+fileName;
        await this.sleep(2000);
        if(process.platform=='win32'){
        var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\nurses\\'+fileName);
        }else{
          var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/nurses/'+fileName);
        }

        try {
          var parent = await Therapist.query().insert({
            mobile: request.input('mobile'),
            name: request.input('name'),
            lastname: request.input('lastname'),
            type:'drugstore',
          
            created_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
            updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ')
          })
        } catch (err) {
          this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
         return response.redirect(request.originalUrl().replace('/create', ''));
        }
    
    
        var data={
          ...request.all(),
          created_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
          updated_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
          password:sha1(request.input('password')),
          name:undefined,
          lastname:undefined,
          "reconfirm-password":undefined,
          therapist_id:parent[0],
          avatar:fileavatar
         };
    
         delete data.name;
         delete data.lastname;
         delete data['reconfirm-password'];

        try {
            var record = await Drugstore.query().insert(data);
            await  Therapist.query().where('id', '=',parent[0]).update({
              type_id:record[0]
            });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Drugstore.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = DrugstoreController



