
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Feedback = use('App/Models/Feedback');
const __ = use('App/Class/Fa');
class FeedbackController extends AdminController {    

      constructor(){
        super();
        this.title="بازخورد";
      }


      async grid({request ,view}){
        var grid=  new Grid(Feedback,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('user_id', __('user_id'));
        grid.column('request_id', __('request_id'));
        grid.column('therapist_id', __('therapist_id'));
        grid.column('star', __('star'));
        grid.column('satisfaction', __('satisfaction'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Feedback);
        if (id != null) {
            await form.edit(id);
        }
                form.text('user_id', __('user_id'));
        form.text('request_id', __('request_id'));
        form.text('therapist_id', __('therapist_id'));
        form.select('star', __('star')).options([{title:1,id:1},{title:2,id:2},{title:3,id:3},{title:4,id:4},{title:5,id:5}]);
        form.text('satisfaction', __('satisfaction'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await Feedback.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        try {
            var record = await Feedback.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Feedback.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = FeedbackController



