
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Holyday = use('App/Models/Holyday');
const __ = use('App/Class/Fa');
class HolyDayController extends AdminController {    

      constructor(){
        super();
        this.title="تعطیلات";
      }


      async grid({request ,view}){
        var grid=  new Grid(Holyday,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('title', __('title'));
        grid.column('holyday', __('holyday')).persiandate();

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Holyday);
        if (id != null) {
            await form.edit(id);
        }
                form.text('title', __('title'));
        form.persiandate('holyday', __('holyday'));

        return form.render();
      }


      async update({ request, view, params, session }) {


        var date = new Date(request.input('holyday')*1);

        date=date;
        
        var ccc={...request.all()};
        ccc.holyday=date;
        try {
            var record = await Holyday.query().where('id', '=', params.id).update({...ccc, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

         

        var date = new Date(request.input('holyday') * 1);

        date=date;

        
        var ccc={...request.all()};
        ccc.holyday=date;

       



        try {
            var record = await Holyday.query().insert({...ccc, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params,response }) {

            try {
                var record = await Holyday.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> حذف با موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response });

      }



}

module.exports = HolyDayController



