
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Page = use('App/Models/Page');
const __ = use('App/Class/Fa');
class PageContoller extends AdminController {    

      constructor(){
        super();
        this.title="صفحات";
      }


      async grid({request ,view}){
        var grid=  new Grid(Page,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('title', __('title'));
        // grid.column('fulltext', __('fulltext'));
        // grid.column('systemable', __('systemable'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Page);
        if (id != null) {
            await form.edit(id);
        }
                form.text('title', __('title'));
        form.editor('fulltext', __('fulltext'));
        // form.text('systemable', __('systemable'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await Page.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        try {
            var record = await Page.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Page.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = PageContoller



