
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const ServiceCategory = use('App/Models/ServiceCategory');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
class ServiceCategoryController extends AdminController {    

      constructor(){
        super();
        this.title="دسته بندی خدمات";
      }


      async grid({request ,view}){
        var grid=  new Grid(ServiceCategory,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('title', __('title'));
        // grid.column('type', __('type'));
        // grid.column('image', __('image'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(ServiceCategory);
        if (id != null) {
            await form.edit(id);
        }
        form.text('title', __('title'));
        form.select('type', __('type')).options([{'title':'پرستاری',id:'nursing'},{'title':'مامائی',id:'midwifery'},{'title':'آزمایشگاه',id:'laboratory'}]);
        form.image('image', __('image'));

        return form.render();
      }


      async update({ request, view, params, session }) {


        const image =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        })

        // return {'test':'test',image:image};

        if(image!=null){
          var fileexists=true;
          var fileName = `${new Date().getTime()}.${image.extname}`
          var fileimage='/uploads/service/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){
          var c=await fs.copyFileSync(image.tmpPath, Helpers.publicPath()+'\\uploads\\service\\'+fileName);
          }else{
            var c=await fs.copyFileSync(image.tmpPath, Helpers.publicPath()+'/uploads/service/'+fileName);
          }
         
        }else{
          var fileexists=false;

        }


       

        try {
            if(fileexists){
              var record = await ServiceCategory.query().where('id', '=', params.id).update({...request.all(),image:fileimage, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            }else{
              var record = await ServiceCategory.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
          
            }
              this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        const image =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        })
        var fileName = `${new Date().getTime()}.${image.extname}`
        var fileimage='/uploads/service/'+fileName;
        await this.sleep(2000);
        if(process.platform=='win32'){
        var c=await fs.copyFileSync(image.tmpPath, Helpers.publicPath()+'\\uploads\\service\\'+fileName);
        }else{
          var c=await fs.copyFileSync(image.tmpPath, Helpers.publicPath()+'/uploads/service/'+fileName);
        }

        try {
            var record = await ServiceCategory.query().insert({...request.all(),image:fileimage, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await ServiceCategory.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = ServiceCategoryController



