
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid = use('App/Class/Grid');
const Form = use('App/Class/Form');
const Therapist = use('App/Models/Therapist');
const __ = use('App/Class/Fa');
class TherapistController extends AdminController {

  constructor() {
    super();
    this.title = "مدیریت درمان گر";
  }


  async grid({ request, view }) {
    var grid = new Grid(Therapist, request.originalUrl());
    grid.column('id', __('Id'));
    grid.column('mobile', __('mobile'));
    grid.column('name', __('name'));
    grid.column('lastname', __('lastname'));
    grid.column('type', __('type'));
    grid.column('type_id', __('type_id'));
    // grid.column('token', __('token'));
    grid.column('last_agent', __('last_agent'));
    grid.column('last_ip', __('last_ip'));
    // grid.column('verify_code', __('verify_code'));

    grid.column('updated_at', __('updatedAt')).persiandate();
    grid.column('created_at', __('createdAt')).persiandate();;
    grid.disableCreation();
    grid.disableDelete();
    // grid.disableEdit();
    return grid.render();
  }


  async form({ request, view }, id = null) {
    var form = new Form(Therapist);
    if (id != null) {
      await form.edit(id);
    }
    if(id==null){
    form.text('mobile', __('mobile'));
    form.text('name', __('name'));
    form.text('lastname', __('lastname'));
    form.text('type', __('type'));
    form.text('type_id', __('type_id'));
    form.text('token', __('token'));
    form.text('last_agent', __('last_agent'));
    form.text('last_ip', __('last_ip'));
    form.text('verify_code', __('verify_code'));
    }else{
      form.text('name', __('name'));
      form.text('lastname', __('lastname'));
      form.select('is_active',__('is_active')).options([{id:1,title:' فعال'},{id:0,title:'غیر فعال'}]);
    }

    return form.render();
  }


  async update({ request, view, params, session }) {

    try {
      var record = await Therapist.query().where('id', '=', params.id).update({ ...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
      this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

    return this.show({ request, view, params, session });

  }


  async   store({ request, view, session,response }) {

    try {
      var record = await Therapist.query().insert({ ...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
      this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

   return response.redirect(request.originalUrl().replace('/create', ''));
  }


  async remove({ request, view, session, params ,response }) {

    try {
      var record = await Therapist.query().where('id', '=', params.id).delete();
      this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

    return this.index({ request, view, session,response});

  }



}

module.exports = TherapistController



