
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const TherapistDeposit = use('App/Models/TherapistDeposit');
const __ = use('App/Class/Fa');
class TherapistDepositController extends AdminController {    

      constructor(){
        super();
        this.title="واریز به تراپیست";
      }


      async grid({request ,view}){
        var grid=  new Grid(TherapistDeposit,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('therapist_id', __('therapist_id'));
        grid.column('amount', __('amount'));
        grid.column('verify', __('verify'));
        grid.column('ref_id', __('ref_id'));
        grid.column('deposit_time', __('deposit_time'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(TherapistDeposit);
        if (id != null) {
            await form.edit(id);
        }
                form.text('therapist_id', __('therapist_id'));
        form.text('amount', __('amount'));
        form.text('verify', __('verify'));
        form.text('ref_id', __('ref_id'));
        form.text('deposit_time', __('deposit_time'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await TherapistDeposit.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        try {
            var record = await TherapistDeposit.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await TherapistDeposit.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = TherapistDepositController



