'use strict'
const User = use('App/Models/User')
const Token = use('App/Models/Token');
const Env = use('Env');

const { validate } = use('Validator')

var Kavenegar = require('kavenegar');





class AuthController {

    async login({ request, response }) {

        var status = "register";
        const validation = await validate(request.all(), {
            mobile: 'required|regex:[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$|min:11|max:11',
        })

        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        if (parseInt(await User.query().where('mobile', '=', request.input('mobile')).getCount()) == 0) {
            var user = new User();
            user.mobile = request.input('mobile');
            await user.save();
        } else {
            var user = await User.query().where('mobile', '=', request.input('mobile')).first();
            status = "login";
        }
        user.validation_code = 10000 + parseInt(Math.floor(Math.random() * Math.floor(89999)));
        if(user.validation_code.length<5){
            user.validation_code="8"+user.validation_code.toString();
        }
        await user.save();
        var api = Kavenegar.KavenegarApi({
            apikey: Env.get('Kavenegar')
        });
        api.VerifyLookup({
            token:  user.validation_code,
            template: 'appGenerateToken',
            receptor: user.mobile,
        },
        function(response, status) {
            console.log(response);
            console.log(status);
        });

        return { code: "200", error: false, message: "کد تایید با موفقیت ارسال شد", data: { status: status } }
    }


    async verify({request,response}){
        const validation = await validate(request.all(), {
            mobile: 'required|regex:[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$|min:11|max:11',
            code:   'required|regex:[0-9]{5}$|min:5|max:5'
        });
        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        var user= await User.query().where('mobile','=',request.input('mobile')).where('validation_code','=',request.input('code')).first();
        if(user==null){
            return { code: "422", error: true, message: "کد تایید صحیح نمی باشد", }
        }

        var result           = '';
        var characters       = 'salammahjava123456789yamahmood09384731379aloapptabibzxcvbnmqwertyui486259ujm';
        var charactersLength = characters.length;
        for ( var i = 0; i < 100; i++ ) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }


        var token=new Token;
        token.user_id=user.id;
        token.token=result;
        token.type='client';
        await token.save();

        return { code: "200", error: false, message: "توکن با موفقیت ایجاد شد", data: { token: token.token } }




    }

}

module.exports = AuthController
