'use strict'

const axios =require('axios');


class DistanceController {


    //35.7454892,51.3732133 برج میلاد

    distance(lat1, lon1, lat2, lon2, unit='k') {
        if ((lat1 == lat2) && (lon1 == lon2)) {
            return 0;
        }
        else {
            var radlat1 = Math.PI * lat1/180;
            var radlat2 = Math.PI * lat2/180;
            var theta = lon1-lon2;
            var radtheta = Math.PI * theta/180;
            var dist = Math.sin(radlat1) * Math.sin(radlat2) + Math.cos(radlat1) * Math.cos(radlat2) * Math.cos(radtheta);
            if (dist > 1) {
                dist = 1;
            }
            dist = Math.acos(dist);
            dist = dist * 180/Math.PI;
            dist = dist * 60 * 1.1515;
            if (unit=="K") { dist = dist * 1.609344 }
            if (unit=="N") { dist = dist * 0.8684 }
            return dist;
        }
    }

    async onlinedistance(lat1, lon1, lat2, lon2){
        var od= await axios.get('https://api.neshan.org/v3/direction?origin='+lat1+','+lon1+'&destination='+lat2+','+lon2+'&avoidTrafficZone=false&avoidOddEvenZone=false',{
            
                headers: { "Api-Key": "service.SoR1eWVfHpFp4YgHLgAgx4N4L2gxAZ9to0uCXpRE"}
            
        })

        
        return JSON.stringify(od.data.routes[0].legs[0]['distance'].value);//['routes']['legs']['distance']['value'];

    }
}

module.exports = DistanceController
