'use strict'

const Therapist = use('App/Models/Therapist');
const Request=use('App/Models/Request');
const UserAddress=use('App/Models/UserAddress');
const { validate } = use('Validator')

var Kavenegar = require('kavenegar');
const Env = use('Env');

class AuthController {

    async login({request,response}){

        const validation = await validate(request.all(), {
            mobile: 'required|regex:[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$|min:11|max:11',
        })

        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }


        var therapist=await Therapist.query().where('mobile', '=', request.input('mobile')).first();


       


        therapist.verify_code = 10000 + parseInt(Math.floor(Math.random() * Math.floor(89999)));
        if(therapist.verify_code.length<5){
            therapist.verify_code="8"+therapist.verify_code.toString();
        }
        

        await therapist.save();

        var api = Kavenegar.KavenegarApi({
            apikey: Env.get('Kavenegar')
        });
        api.VerifyLookup({
            token:  therapist.verify_code,
            template: 'appGenerateToken',
            receptor: therapist.mobile,
        },
        function(response, status) {
            console.log(response);
            console.log(status);
        });



        return { code: "200", error: false, message: "کد تایید با موفقیت ارسال شد" }

    }


    async verify({request,response}){
        const validation = await validate(request.all(), {
            mobile: 'required|regex:[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$|min:11|max:11',
            code:   'required|regex:[0-9]{5}$|min:5|max:5'
        });
        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        var t= await Therapist.query().where('mobile','=',request.input('mobile')).where('verify_code','=',request.input('code')).first();
        if(t==null){
            return { code: "422", error: true, message: "کد تایید صحیح نمی باشد", }
        }

        var result           = '';
        var characters       = 'salammahjava123456789yamahmood09384731379aloapptabibzxcvbnmqwertyui486259ujm';
        var charactersLength = characters.length;
        for ( var i = 0; i < 100; i++ ) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }


        t.token=result
        t.save();

        var r= await Request.query().where('therapist_id','=',t.id).whereNotIn('status',['done','cancel','return','request']).with('user').first();
        if(r!=null){
        var ua=await UserAddress.query().where('id','=', r.user_address_id).where('user_id','=',r.user_id).first();

        var requestdata=r.toJSON();
        requestdata.message={
            latitude:ua.latitude,
            longitude:ua.longitude,
            request_id:r.id
        }

        var mahjava={username: r.user.mobile,
        requestdata:requestdata,
        request_id:r.id,
        address:ua,
        user:{
          mobile:r.user.mobile,
          fullname:r.user.fullname,
        },
        message:{
            latitude:ua.latitude,
            longitude:ua.longitude
        }
        }

    }else{
        var mahjava =null;
    }



        

        return { code: "200", error: false, message: "توکن با موفقیت ایجاد شد", data: { token: t.token,data:mahjava } }




    }

}

module.exports = AuthController
