'use strict'


const UserWallet = use('App/Models/UserWallet');

var sha256 = require('sha256');

const LaboratoryInstruction = use('App/Models/LaboratoryInstruction');
const Prescription = use('App/Models/Prescription');

class UserWalletManagerController {


    async rePayemnt({request,params}){
        if(request.input('type')=='lab'){
            var record=await LaboratoryInstruction.query().where('id','=',params.id).first();
            var type='LaboratoryInstruction';
            var descriptions ='کسر '+' '+record.price+' تومان '+' مبلغ بابت پرداخت هزینه آزمایشگاه';

        }else{
            var record=await Prescription.query().where('id','=',params.id).first();
            var type='Prescription';
            var descriptions ='کسر '+' '+record.price+' تومان '+' مبلغ بابت پرداخت هزینه داروخانه';
        }
        
        var balacne=this.showBalance({request})

        if(record.status=='unpaid'){

        

            if(record.price>balacne){
                return {code:'200',error:true,message:'اعتبار کافی نمی باشد'}
            }else{
                this.Decrease(request.user.id,record.price,type,record.id,descriptions);
                record.status='paid';
                await record.save();
                return {code:'200',error:false,message:'با موفقیت پرداخت شد'}


            }

        }else{
            return {code:'200',error:true,message:'قبلا پرداخت شده است'}
        }
        

    }

    async showWallet({request}){
        var myuv=await UserWallet.query().where('user_id','=',request.user.id).fetch();
        return myuv.toJSON();

    }

    async showBalance({request}){
        var sum=await UserWallet.query().where('user_id','=',request.user.id).getSum('amount');
        return sum;
    }

    async Increase(userId, amount, type = null, type_id = null, descriptions = null) {

        if (parseInt(amount) > 0) {
            let uv = new UserWallet();
            uv.user_id = userId;
            uv.amount = parseInt(amount);
            uv.type = type;
            uv.type_id = type_id;
            uv.descriptions = descriptions;

            var lastuv = await UserWallet.query().where('user_id', '=', userId).orderBy('id', 'desc').first();

            var lasthash = null;
            if (lastuv != null) {
                lasthash = lastuv.hash
            }
            await uv.save();



            var mystr = sha256(JSON.stringify({ ...uv.toJSON(), hash: lasthash }))



            uv.hash = mystr;

            await uv.save();




        }

    }



    async Decrease(userId, amount, type = null, type_id = null, descriptions = null){

        if (parseInt(amount) > 0) {
            let uv = new UserWallet();
            uv.user_id = userId;
            uv.amount = parseInt(amount)*(-1);
            uv.type = type;
            uv.type_id = type_id;
            uv.descriptions = descriptions;

            var lastuv = await UserWallet.query().where('user_id', '=', userId).orderBy('id', 'desc').first();

            var lasthash = null;
            if (lastuv != null) {
                lasthash = lastuv.hash
            }
            await uv.save();



            var mystr = sha256(JSON.stringify({ ...uv.toJSON(), hash: lasthash }))



            uv.hash = mystr;

            await uv.save();




        }

    }
}


module.exports = UserWalletManagerController
