'use strict'
const Laboratory = use('App/Models/Laboratory');
const Cryptr = require('cryptr');
const cryptr = new Cryptr('mahjava');
const LaboratoryInstruction = use('App/Models/LaboratoryInstruction');
const Helpers = use('Helpers');
const mkdirp = require('mkdirp');
var Kavenegar = require('kavenegar');
const Env = use('Env');
class LabaratoryController {
  constructor({ socket, io, $client }) {
    console.log('make socket labratory');
    this.socket = socket
    this.io = io
    this.$client=$client
    this.request_created_at=null;
    this.request_id=null;

    this.files = {},
    this.struct = {
        name: null,
        type: null,
        size: 0,
        data: [],
        slice: 0,
    };
    this.fs= require('fs');

    var selflabratory=this;
    this.socket.on('join to labratory',async function(data){
      console.log(data);
      var ds=await selflabratory.login(data.token);
      console.log(ds);
      if(ds!=null){
        selflabratory.socket.drugid=ds.id;
        selflabratory.socket.druguser=ds.mobile;


        selflabratory.socket.join('ready labratory');
        selflabratory.io.to('ready labratory').emit('new message',{
          username:selflabratory.socket.druguser,
          message:'join  labratory',
        })
      }

    });


    this.socket.on('leave labratory',async function(data){
      selflabratory.socket.leave('ready labratory');
      selflabratory.socket.emit('new message',{
        username:selflabratory.socket.druguser,
        message:'leave  labratory',
      })
    })

    this.socket.on('accept order',async function(data){

      var ds=await selflabratory.login(data.token);
     

      if(ds!=null){
        var myps=await LaboratoryInstruction.query().whereNull('therapist_laboratory_id').whereIn('status',['request','paid']).where('id','=',data.id).where('created_at','=',data.created_at).with('address').first();
        console.log("====  myps  ====")
        console.log(myps);
        myps.therapist_laboratory_id=ds.id;

        if(myps.image!=null){
       
        myps.status='accept';
        }
        
        await myps.save();
        selflabratory.io.to('ready labratory').emit('accept order',{
          username:selflabratory.socket.druguser,
          message:myps,
        })

      }

    })

    this.socket.on('set order price',async function(data){
      var ds=await selflabratory.login(data.token);
      if(ds!=null){
      var myps=await LaboratoryInstruction.query().where('therapist_laboratory_id','=',ds.id).whereIn('status',['accept','paid']).where('id','=',data.id).where('created_at','=',data.created_at).with('address').with('therapist').first();
      myps.status='unpaid';

      

      myps.price=data.price;
      await myps.save();
      var user = await myps.user().fetch();

      await selflabratory.$client.sendCloudMessage(
        'تغییر وضعیت آزمایش'
        ,'آزمایش در انتظار پرداخت شما می باشد',
        myps.user_id);


      selflabratory.io.to('private_client_' + user.mobile).emit('nextstatus', {
        request: myps
      });
      selflabratory.socket.emit('set order price',{...myps});


    }
    });

    this.socket.on('next status',async function(data){

      console.log('next status')

      var ds=await selflabratory.login(data.token);

      if(ds!=null){
      var myps=await LaboratoryInstruction.query().where('therapist_laboratory_id','=',ds.id).whereIn('status',['paid','sampling']).where('id','=',data.id).where('created_at','=',data.created_at).with('address').with('therapist').first();
      //.with('therapist.detail')
      if(myps.status=='sampling'){
        myps.status='test';
      }
      if(myps.status=='paid'){
        myps.status='sampling';
      }
      try{
      await myps.save();
      console.log('save');
      var user = await myps.user().fetch();
      selflabratory.io.to('private_client_' + user.mobile).emit('nextstatus', {
        request: myps
      });

     

      if(myps.status=='sampling'){
        await selflabratory.$client.sendCloudMessage(
          'تغییر وضعیت آزمایش ',
          'آزمایش به در حال نمونه گیری تغیر وضعیت یافت'
          ,myps.user_id);
      }

      if(myps.status=='test'){
        await selflabratory.$client.sendCloudMessage(
         
          'تغییر وضعیت آزمایش ',
          'آزمایش به شروع آزمایش تغیر وضعیت یافت'
          ,myps.user_id);
      }
      
      }catch(e){
        console.log(e);
      }
      selflabratory.socket.emit('next status',{...myps});
      }
    });

    this.socket.on('create test file', async function(data){
      var ds=await selflabratory.login(data.token);

      selflabratory.request_id=data.id;
      selflabratory.request_created_at=data.created_at;


    });



    this.socket.on('test file slice upload', async (data) => {
      var ds=await selflabratory.login(data.token);
      if (!selflabratory.files[data.name]) {
        selflabratory.files[data.name] = Object.assign({}, selflabratory.struct, data);
        selflabratory.files[data.name].data = [];
      }

      //convert the ArrayBuffer to Buffer 
      data.data = new Buffer(data.data);
      // data.data = new Buffer(new Uint8Array(data.data));
      
      //save the data 
      selflabratory.files[data.name].data.push(data.data);
      selflabratory.files[data.name].slice++;

      if (selflabratory.files[data.name].slice * 20000 >= selflabratory.files[data.name].size) {


        var li=await LaboratoryInstruction.query().where('therapist_laboratory_id','=',ds.id).whereIn('status',['test']).where('id','=',selflabratory.request_id).where('created_at','=',selflabratory.request_created_at).with('address').with('therapist').first();
      //  .with('therapist.detail')
        console.log(selflabratory.files[data.name])

        console.log("\r\n");
        console.log("\r\n");
        console.log("\r\n");
        console.log(Helpers.publicPath('/uploads/response/test/'+ds.id+'/'));
        if (!selflabratory.fs.existsSync(Helpers.publicPath('/uploads/response/test/'+ds.id))) {
           selflabratory.fs.mkdirSync(Helpers.publicPath('/uploads/response/test/'+ds.id),{ recursive: true });
        }
        
        console.log("\r\n");
        console.log("\r\n");
        var n=Date.now();
        var pathfile=Helpers.publicPath('/uploads/response/test/'+ds.id+'/'+n+data.name);

        console.log(data.name);
        selflabratory.files[data.name].data.forEach(async function(d){
          console.log("\r\n");
          console.log(d);
          console.log("\r\n");

          await selflabratory.fs.appendFileSync(pathfile, d, 'binary');
         


        });
        console.log("\r\n 99")
       
        
       
        li.status='done';
        li.test_file='/uploads/response/test/'+ds.id+'/'+n+data.name;
       
        
        console.log("\r\n 107")
        var user = await li.user().fetch();

     
        var api = Kavenegar.KavenegarApi({
          apikey: Env.get('Kavenegar')
        });
        console.log(user.mobile);
        api.VerifyLookup({
          token: 'آزمایش',
          template: 'appEndProcess',
          receptor: user.mobile,
        },
          function (response, status) {
            console.log("\r\n");
            console.log(" ===  103 ====");
            console.log("\r\n");
            console.log(response);
            console.log(status);
          });
        selflabratory.io.to('private_client_' + user.mobile).emit('nextstatus', {
          request: li
        });
        await li.save();

        


        await selflabratory.$client.sendCloudMessage(
          'تغییر وضعیت آزمایش'
          ,'شما می توانید با مراجعه به بخش سوابق ، جواب آزمایش خود را مشاهده نمایید.',
          li.user_id);


        delete selflabratory.files[data.name];

      
        //do something with the data 
        selflabratory.socket.emit('test file end upload',{id:li.id,attachfilenumer:selflabratory.attachfilenumer});
        console.log("\r\n 170")

        
      } else {
        console.log('test file slice upload');
        selflabratory.socket.emit('test file slice upload', {
          currentSlice: selflabratory.files[data.name].slice
        });
      }
    });

  }


  async login(token){

    var myarray= token.split("==");
    var mobile=myarray[0];
    var hash=myarray[1];
    var ds=await Laboratory.query().where('mobile','=',mobile).where('password','=', cryptr.decrypt(hash)).first();
    return ds;

  }
}

module.exports = LabaratoryController
