'use strict'

const Helpers = use('Helpers');
const mkdirp = require('mkdirp');
const ServicePricing=use ('App/Models/ServicePricing');
const ServiceCategory =use ('App/Models/ServiceCategory');
const UserAddress = use('App/Models/UserAddress');
const UserWalletManagerController=use('App/Controllers/Http/UserWalletManagerController');
const Request=use('App/Models/Request');
class MidwifeController {
  constructor ({ socket, io ,$client}) {
    this.socket = socket;
    this.io = io;
    this.clienttoken=null;
    this.userclient=null;
    this.request_id=null; 
    this.description=null;
    this.insurance_id=null;
    this.extra=null,
    this.user_address_id=null;
    this.files = {},
      this.struct = {
        name: null,
        type: null,
        size: 0,
        data: [],
        slice: 0,
      };
    this.$client=$client;  
    this.fs= require('fs');
    var filemanager = this;

    this.socket.on('Midwife request', async (data)=>{
      console.log("\r\n 26")
      filemanager.userclient=await filemanager.$client.login(data.token);
      console.log(filemanager.userclient);
      if(filemanager.userclient!=null){
        filemanager.clienttoken=data.token;
       
        this.clienttoken=data.token;
        this.description=data.description;
        this.insurance_id=data.insurance_id;
        this.extra=data.extra;
        this.request_id=null;
        console.log("\r\n");
        console.log("=== address uuid ===");
        console.log("\r\n");
        console.log( data.addressuuid);
        var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',filemanager.userclient.id).first();
        
        filemanager.user_address_id=ua.id;
        console.log(ua);
       
        console.log(filemanager.extra);
        var Balance=await filemanager.userclient.wallet().getSum('amount');
        

        var price = 0;

        await filemanager.extra.forEach(async function (e) {
          price = parseInt(price) + parseInt(e.price) * parseInt(e.count);
        });


        if(Balance<price){
        this.socket.emit('new message',{
          username:' مدیر مالی ',
          message:'موجودی شما = '+Balance + 'تومان'  
        })
        return this.socket.emit('new message',{
          username:' مدیر سیستم ',
          message:'برای دریافت این خدمت باید '+price+' تومان موجودی داشته باشید' 
    
        })
        }else{
          var li=new Request;
          li.user_id=filemanager.userclient.id;
          li.status='request';
          li.serivce='midwife';

         
          li.price=price;
        
          li.description=filemanager.description;
    
          li.extra=JSON.stringify(filemanager.extra);
          
          li.user_address_id=filemanager.user_address_id;
          await li.save();
          console.log("\r\n 51")
    
          let uwm=new UserWalletManagerController;
          await uwm.Decrease(filemanager.userclient.id,price,'request',li.id,'کسر مبلغ '+price+'درخواست ماما ');
          await filemanager.$client.sendCloudMessage('مالی','کسر مبلغ '+price+' درخواست ماما ',filemanager.userclient.id);
          li.status='paid';
          await li.save();
          filemanager.socket.emit('Midwife request log','ثبت با موفقیت انجام شد');
    
        }
      }else{
        filemanager.socket.emit('Midwife request log','خطا در اهراز هویت');
      }
      
  });
  }
}

module.exports = MidwifeController
