'use strict'
const Helpers = use('Helpers')
const mkdirp = require('mkdirp');
const Prescription = use('App/Models/Prescription');
const UserAddress = use('App/Models/UserAddress');


class PrescriptionManagerController {
  constructor({ socket, io, $client }) {
    this.socket = socket;
    this.io = io;
    this.clienttoken = null;
    this.userclient = null;
    this.request_id = null;
    this.description = null;
    this.insurance_id = null;
    this.user_address_id = null;
    this.attachfilenumer = 1;
    this.files = {},
      this.struct = {
        name: null,
        type: null,
        size: 0,
        data: [],
        slice: 0,
      };
    this.$client = $client;
    this.fs = require('fs');
    var filemanager = this;

    this.socket.on('Prescription client create', async (data) => {
      filemanager.userclient = await filemanager.$client.login(data.token);
      if (filemanager.userclient != null) {
        filemanager.clienttoken = data.token;
        filemanager.clienttoken = data.token;
        filemanager.description = data.description;
        filemanager.insurance_id = data.insurance_id;
        var ua = await UserAddress.query().where('uuid', '=', data.addressuuid).where('user_id', '=', filemanager.userclient.id).first();
        filemanager.user_address_id = ua.id;
        filemanager.request_id = null;
        filemanager.socket.emit('Prescription log', 'create base Prescription.should send file');
      } else {
        filemanager.socket.emit('Prescription log', 'user not valid token');
      }

    });




    this.socket.on('Prescription client slice upload', async (data) => {
      if (!filemanager.files[data.name]) {
        filemanager.files[data.name] = Object.assign({}, filemanager.struct, data);
        filemanager.files[data.name].data = [];
      }

      //convert the ArrayBuffer to Buffer 
      data.data = new Buffer(data.data);
      // data.data = new Buffer(new Uint8Array(data.data));

      //save the data 
      filemanager.files[data.name].data.push(data.data);
      filemanager.files[data.name].slice++;

      if (filemanager.files[data.name].slice * 20000 >= filemanager.files[data.name].size) {

        console.log(filemanager.files[data.name])

        console.log("\r\n");
        console.log("\r\n");
        console.log("\r\n");
        console.log(Helpers.publicPath('/uploads/prescription/client/' + socket.username + '/'));
        if (!filemanager.fs.existsSync(Helpers.publicPath('/uploads/prescription/client/' + socket.username))) {
          filemanager.fs.mkdirSync(Helpers.publicPath('/uploads/prescription/client/' + socket.username), { recursive: true });
        }

        console.log("\r\n");
        console.log("\r\n");
        var n = Date.now();
        var pathfile = Helpers.publicPath('/uploads/prescription/client/' + socket.username + '/' + n + data.name);

        filemanager.files[data.name].data.forEach(async function (d) {
          console.log("\r\n");
          console.log(d);
          console.log("\r\n");

          await filemanager.fs.appendFileSync(pathfile, d, 'binary');



        });
        var ps = new Prescription;
        ps.user_id = filemanager.userclient.id;
        ps.status = 'request';
        ps.image = '/uploads/prescription/client/' + socket.username + '/' + n + data.name;
        ps.insurance_id = filemanager.insurance_id;
        ps.description = filemanager.description;
        ps.user_address_id = filemanager.user_address_id;

        var ss = await ps.save();
        console.log('=== ps ===')
        console.log(ps.id);

        ps.address = await ps.address().fetch();



        // filemanager.io.to('ready drugstore').emit('new order',{username:filemanager.socket.username,message:ps})
        //do something with the data 
        filemanager.socket.emit('Prescription client end upload',{id:ps.id,attachfilenumer:filemanager.attachfilenumer});

        filemanager.socket.emit('new message', { username: socket.username, message: '<img width="320" src="/uploads/prescription/client/' + socket.username + '/' + n + data.name + '"/>' });
      } else {
        console.log('Prescription client request slice upload');
        filemanager.socket.emit('Prescription client request slice upload', {
          currentSlice: filemanager.files[data.name].slice
        });
      }
    });



    this.socket.on('Prescription client slice two upload', async (data) => {

      if (!filemanager.files[data.name]) {
        filemanager.files[data.name] = Object.assign({}, filemanager.struct, data);
        filemanager.files[data.name].data = [];
      }

      //convert the ArrayBuffer to Buffer 
      data.data = new Buffer(data.data);
      // data.data = new Buffer(new Uint8Array(data.data));

      //save the data 
      filemanager.files[data.name].data.push(data.data);
      filemanager.files[data.name].slice++;

      if (filemanager.files[data.name].slice * 20000 >= filemanager.files[data.name].size) {

        console.log(filemanager.files[data.name])

        console.log("\r\n");
        console.log("\r\n");
        console.log("\r\n");
        console.log(Helpers.publicPath('/uploads/Prescription/client/' + filemanager.userclient.mobile + '/'));
        if (!filemanager.fs.existsSync(Helpers.publicPath('/uploads/Prescription/client/' + filemanager.userclient.mobile))) {
          filemanager.fs.mkdirSync(Helpers.publicPath('/uploads/Prescription/client/' + filemanager.userclient.mobile), { recursive: true });
        }

        console.log("\r\n");
        console.log("\r\n");
        var n = Date.now();
        var pathfile = Helpers.publicPath('/uploads/Prescription/client/' + filemanager.userclient.mobile + '/' + n + data.name);

        console.log(data.name);
        filemanager.files[data.name].data.forEach(async function (d) {
          console.log("\r\n");
          console.log(d);
          console.log("\r\n");

          await filemanager.fs.appendFileSync(pathfile, d, 'binary');



        });
        console.log("\r\n 99")

        console.log(data.prescription_instruction_id);


        var li = await Prescription.query().where('id', '=', data.prescription_instruction_id).first();


        //console.log(typeof li);



        li.status = 'request';
        li.image += ("\r\n" + '/uploads/Prescription/client/' + filemanager.userclient.mobile + '/' + n + data.name);
        console.log(li.image);

        await li.save();


        delete filemanager.files[data.name];


        //do something with the data 
        filemanager.socket.emit('Prescription client two end upload', { id: li.id, attachfilenumer: filemanager.attachfilenumer });
        console.log("\r\n 249")

        filemanager.socket.emit('new message', { username: socket.username, message: '<img width="320" src="/uploads/Prescription/client/' + socket.username + '/' + n + data.name + '"/>' });
      } else {
        console.log('Prescription client request slice two upload');
        filemanager.socket.emit('Prescription client request slice two upload', {
          currentSlice: filemanager.files[data.name].slice,
          id: data.prescription_instruction_id,
          attachfilenumer: filemanager.attachfilenumer,
        });
      }

    });

  }
}


module.exports = PrescriptionManagerController
