'use strict'
/** @typedef {import('@adonisjs/framework/src/Request')} Request */
/** @typedef {import('@adonisjs/framework/src/Response')} Response */
/** @typedef {import('@adonisjs/framework/src/View')} View */

const Token = use('App/Models/Token');
const User = use('App/Models/User');

class AuthClient {
  /**
   * @param {object} ctx
   * @param {Request} ctx.request
   * @param {Function} next
   */
  async handle ({ request,params,response }, next) {

    if(typeof params.token!='undefined'){
      var t=params.token;
    }else{
      var t=request.headers().authorization
    }

    var token=await Token.query().where('token','=',t).first();
    var user=null;
    if(token!=null)
        user=await User.find(token.user_id);


    if(user==null){
      return   response.send({ code: "403", error: true, message: "اهراز هویت انجام نشد"});
    }

    request.user=user.toJSON();
    
    await next()
  }
}

module.exports = AuthClient
