'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class UserSchema extends Schema {
  up () {
    this.create('users', (table) => {
      table.increments()
      table.string('mobile',100).notNullable().unique();
      table.string('validation_code').nullable();
      table.uuid('uuid');
      table.string('email').nullable();
      table.date('birthdate').nullable();
      table.string('fullname').nullable();
      table.timestamps()
    })
  }

  down () {
    this.drop('users')
  }
}

module.exports = UserSchema
