'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class AdminMenuSchema extends Schema {
  up () {
    this.create('admin_menu', (table) => {
      table.increments()
      table.integer('parent_id').nullable();
      table.integer('order').default(0);
      table.string('title');
      table.string('icon');
      table.string('permission').nullable();
      table.string('uri');
      table.timestamps()
    })
  }

  down () {
    this.drop('admin_menu')
  }
}

module.exports = AdminMenuSchema
