'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class DrugstoresSchema extends Schema {
  up () {
    this.create('drugstores', (table) => {
      table.increments()
      table.integer('therapist_id').unsigned().references('id').inTable('therapists')
      table.string('license_number');
      table.string('tel');
      table.string('mobile');
      table.string('bank');
      table.string('account_number');
      table.string('card_number');
      table.string('sheba_number');
      table.string('avatar');
      table.text('address');
      table.text('economic_code');
      table.string('contract_number');
      table.uuid('uuid');
      table.float('latitude',10,6);
      table.float('longitude',10,6);
      table.string('password');
      table.timestamps()
    })
  }

  down () {
    this.drop('drugstores')
  }
}

module.exports = DrugstoresSchema
