'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class TherapistWalletsSchema extends Schema {
  up () {
    this.create('therapist_wallets', (table) => {
  
      table.increments()
      table.integer('therapist_id').unsigned().references('id').inTable('therapists')
      table.integer('amount');
      table.string('type');
      table.integer('type_id');
      table.text('descriptions');
      table.string('hash');
      table.uuid('uuid');
      table.timestamps()
 
    })
  }

  down () {
    this.drop('therapist_wallets')
  }
}

module.exports = TherapistWalletsSchema
