'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class ProductsSchema extends Schema {
  up () {
    this.create('products', (table) => {
      table.increments();
      table.integer('category_id').unsigned().references('id').inTable('categories')
      table.string('title');
      table.integer('price');
      table.string('image');
      table.text('description');
      table.uuid('uuid');
      table.timestamps();
    })
  }

  down () {
    this.drop('products')
  }
}

module.exports = ProductsSchema
