'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class TransactionSchema extends Schema {
  up () {
    this.create('transactions', (table) => {
      table.increments();
      
      table.integer('user_id').unsigned().references('id').inTable('users')

      table.integer('amount');
      

      table.enum('status',['unpaid','paid']);

      table.enum('getway',['zarinpal','mellat']);

      table.string('digital_code');


      table.timestamps();
    })
  }

  down () {
    this.drop('transactions')
  }
}

module.exports = TransactionSchema
