'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class LaboratoryInstructionsSchema extends Schema {
  up () {
    this.create('laboratory_instructions', (table) => {
      table.increments()
      table.integer('user_id');
      table.integer('therapist_id').nullable();
      table.integer('request_id').nullable();
      table.integer('therapist_laboratory_id');
      table.integer('price').nullable();
      table.enum('status',['register','request','accept','unpaid','paid','onway','sampling','test','deliver']);
      table.string('image');
      table.text('description');
      table.integer('insurance_id').nullable();
      table.text('extra');
      table.integer('user_address_id').nullable().unsigned().references('id').inTable('user_addresses');
      table.timestamps()
    })
  }

  down () {
    this.drop('laboratory_instructions')
  }
}

module.exports = LaboratoryInstructionsSchema
