'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class UserFirebaseTokenSchema extends Schema {
  up () {
    this.create('user_firebase_tokens', (table) => {
      table.increments()
      table.integer('user_id').unsigned().references('id').inTable('users');
      table.text('token');
      table.timestamps()
    })
  }

  down () {
    this.drop('user_firebase_tokens')
  }
}

module.exports = UserFirebaseTokenSchema
