'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class UserShopAddressesSchema extends Schema {
  up () {
    this.create('user_shop_addresses', (table) => {
      table.increments()
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.text('address');
      table.string('city');
      table.string('state');
      table.string('name');
      table.string('mobile');
      table.float('latitude');
      table.float('longitude');
      table.uuid('uuid');
      table.timestamps()
    })
  }

  down () {
    this.drop('user_shop_addresses')
  }
}

module.exports = UserShopAddressesSchema
