'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class TherapistDepositsSchema extends Schema {
  up () {
    this.create('therapist_deposits', (table) => {
      table.increments()
      table.integer('therapist_id');
      table.integer('amount');
      table.boolean('verify');
      table.text('ref_id');
      table.datetime('deposit_time')
      table.timestamps()
    })
  }

  down () {
    this.drop('therapist_deposits')
  }
}

module.exports = TherapistDepositsSchema
