'use strict'

/*
|--------------------------------------------------------------------------
| Websocket
|--------------------------------------------------------------------------
|
| This file is used to register websocket channels and start the Ws server.
| Learn more about same in the official documentation.
| https://adonisjs.com/docs/websocket
|
| For middleware, do check `wsKernel.js` file.
|
*/

//make socket io;
const Server = use('Server')
const io = use('socket.io')(Server.getInstance())


//use models
const Token = use('App/Models/Token');
const User = use('App/Models/User');
const Request=use('App/Models/Request');
const Prescription = use('App/Models/Prescription');
const LaboratoryInstruction = use('App/Models/LaboratoryInstruction');
const ServicePricing =use ('App/Models/ServicePricing');
const SamplingSan = use ('App/Models/SamplingSan');
const ServiceCategory = use ('App/Models/ServiceCategory');
const Config = use ('App/Models/Config');
const UserFirebaseToken = use('App/Models/UserFirebaseToken');
const UserMessage = use('App/Models/UserMessage');


const Log= use('App/Models/Log');





var moment=require('moment');

//use controller
const ClientController=use('App/Controllers/Ws/Socket/ClientController');
const TherapistController=use('App/Controllers/Ws/Socket/TherapistController');
const FileManagerController=use('App/Controllers/Ws/Socket/FileManagerController');
const PrescriptionManagerController=use('App/Controllers/Ws/Socket/PrescriptionManagerController');
const LaboratoryInstructionsManagerController=use('App/Controllers/Ws/Socket/LaboratoryInstructionsManagerController');
const DrugStoreController=use('App/Controllers/Ws/Socket/DrugStoreController');
const LabaratoryController=use('App/Controllers/Ws/Socket/LabaratoryController');
const NurseController=use('App/Controllers/Ws/Socket/NurseController');
const MidwifeController=use('App/Controllers/Ws/Socket/MidwifeController');
const UserWalletManagerController=use('App/Controllers/Http/UserWalletManagerController');

//cron job
const axios =require('axios');
const Env = use('Env');
var sendCloudMessageforjob=async function(title,body,user){

  var uft= await UserFirebaseToken.query().where('user_id','=',user).orderBy('id','desc').fetch();

  uft = uft.toJSON();

  var um=new UserMessage;
  um.user_id=user;
  um.title=title;
  um.message=body;

  await um.save();

  console.log(Env.get('firebaseserverkey'));



  var fbskey=Env.get('firebaseserverkey');

 
  uft.forEach(async function(element) {

    console.log(fbskey);
    console.log("\r\n");
    console.log(element.token);

    try{
      axios.defaults.headers.common["A"]="A";
      axios.defaults.headers.common["Authorization"] = "key=AAAAkfGWmkA:APA91bHc0i6UBtgihjpiKxP76xu7-fR3OZeOizjYW548vFq51fBcUUEP0o3a3iY4-kbkBG1lQtjzRyZSxsT5RhjwrC6nsB5x6oggH0Zk1BHnDV21z-toGcV5rAM7x2YxCvbPwBLO5pf8"
      axios.defaults.headers.post["Content-Type"] = "application/json"

      await axios.post('https://fcm.googleapis.com/fcm/send', {
      "content_available": true,
      "mutable_content": true,
      "priority":"high",
      "data" : {
           "imageURL": "https://static.tgju.org/images/iwmf-3.png",
           "app": "1.0",
           "syntax": "swift",
           "type": "notic",
           "source": {
               "storyboardID": "TESTVC",
               "message": "<TESTMESSAGE>",
               "duration": 0
           }
      },
      "to": element.token,
     "notification": {
           "title": title,
           "body": body,
           "sound": "default",
           "badge": 1,
           "icon":"https://static.tgju.org/images/iwmf-3.png"
     },
     "webpush": {
           "fcm_options": {
             "link": "https://dummypage.com"
           }
         }
});

// "comment_click_action": "https://aloapp.com",
//  "click_action":"blog",
//  "url":"https://aloapp.com",


//  {
//   headers:{
//       "Authorization":("key="+fbskey),
//       "Content-Type":"application/json"
//   }
// }
  console.log('ok');
}catch(e){
  console.log("error 102");
  console.log(e);
}

  console.log( {headers:{
    Authorization:("key="+fbskey)
}});
     
  });

  

 return "send ok";
  
}
setInterval(async function(){


  

 


  var drugStoreTimeOut= await Config.query().where('name','=','drugStoreTimeOut').first();
  var LabTimeOut= await Config.query().where('name','=','LabTimeOut').first();
  var midwifeTimeOut= await Config.query().where('name','=','midwifeTimeOut').first();
  var nurseTimeOut= await Config.query().where('name','=','nurseTimeOut').first();
  var doctorTimeOut= await Config.query().where('name','=','doctorTimeOut').first();
  
  var now=moment().toDate().toISOString().slice(0, 19).replace('T', ' ');
  var clears1=await Request.query().where('status','=','request').whereIn('serivce',['clienthealthcertificate','clienthomevisit','clientdeathcertificate']).where('updated_at','<',moment().subtract(doctorTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'cancel'})
  var clears2=await Request.query().where('status','=','request').whereIn('serivce',['midwife']).where('updated_at','<',moment().subtract(midwifeTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'return'})

  var clears3=await Request.query().where('status','=','paid').whereIn('serivce',['nurse']).where('updated_at','<',moment().subtract(nurseTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'cancel'})
  var clears4=await Request.query().where('status','=','request').whereIn('serivce',['nurse']).where('updated_at','<',moment().subtract(nurseTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'return'})
  var clears5=await Request.query().where('status','=','paid').whereIn('serivce',['midwife']).where('updated_at','<',moment().subtract(midwifeTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'cancel'})
  var clears6=await Prescription.query().where('status','=','unpaid').where('updated_at','<',moment().subtract(drugStoreTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'return'})
  var clears7=await LaboratoryInstruction.query().where('status','=','unpaid').where('updated_at','<',moment().subtract(LabTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_id:null,status:'return'})
  

  console.log(now);
  // console.log(now);

  // console.clear();

  // console.log('run cron job '+now);

  
  // console.log(moment().subtract(10, 'minutes').format('YYYY-MM-DD HH:mm:ss'));


  // var sql=  Prescription.query().where('status','=','accept').where('updated_at','>',moment().subtract(5, 'minutes').toDate()).toSQL();
  // sql=sql.sql;

  // sql=sql.replace('?','accept')
  // sql=sql.replace('?',moment().subtract(5, 'minutes').format('YYYY-MM-DD HH:mm:ss'));
  // console.log(sql);


  




  var cronps= await Prescription.query().where('status','=','accept').where('updated_at','<',moment().subtract(drugStoreTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_drogstore_id:null,status:'request'})
  var cronLi= await LaboratoryInstruction.query().where('status','=','accept').where('updated_at','<',moment().subtract(LabTimeOut.value, 'minutes').format('YYYY-MM-DD HH:mm:ss')).update({ therapist_laboratory_id:null,status:'request'})
  
  // console.log(cronps);

  var oneps=await Prescription.query().where('status','=','request').orderByRaw('rand()').first();
  var oneLI=await LaboratoryInstruction.query().whereIn('status',['request','paid']).whereNull('therapist_laboratory_id').orderByRaw('rand()').first();
  // .where('therapist_laboratory_id','=',null)
 
  if(oneps!=null){
    oneps.address=await oneps.address().fetch();
    // console.log(oneps.id);
    io.to('ready drugstore').emit('new order',{username:'system',message:oneps})
  }else{
    // console.log(oneps);
  }

  if(oneLI!=null){
    
    oneLI.address=await oneLI.address().fetch();


    var sc=await ServiceCategory.query().where('type','=','laboratory').fetch();
          

    sc= sc.toJSON();

    var scid=[];

    sc.forEach(element => {
      scid.push(element.id);
    });

    


    var listextra=await ServicePricing.query().whereIn('category_id',scid).fetch();

    var sans=await SamplingSan.query().fetch();

    oneLI.listextra=listextra.toJSON();
    oneLI.sans=sans.toJSON();
  
    console.log(oneLI.id);
    io.to('ready labratory').emit('new order',{username:'system',message:oneLI})
  }else{
    // console.log(oneps);
  }





  var rrrequest=await Request.query().whereIn('status',['paid','request']).where('serivce','=','clienthomevisit').with('user').with('address').orderByRaw('rand()').first();
  if(rrrequest!=null){
    rrrequest=rrrequest.toJSON();
  var data={};
  data.request_id=rrrequest.id;  
    data.description=rrrequest.description;
    data.price=rrrequest.price;
    data.therapist='doctors';
    data.type='clienthomevisit';

    data.latitude= rrrequest.address.latitude;
    data.longitude= rrrequest.address.longitude;
   
    data.addressuuid=rrrequest.address.uuid;

  io.to('ready').emit('clienthomevisit', {
    username: 'system',
    message: data,
    request_id:data.request_id,
    address:rrrequest.address,
    user:{
      mobile:rrrequest.user.mobile,
      fullname:rrrequest.user.fullname,
    }
  });
}

  var rrrequest=await Request.query().whereIn('status',['paid','request']).where('serivce','=','clienthealthcertificate').with('user').with('address').orderByRaw('rand()').first();
  if(rrrequest!=null){
    rrrequest=rrrequest.toJSON();
  var data={};
  data.request_id=rrrequest.id;  
    data.description=rrrequest.description;
    data.price=rrrequest.price;
    data.therapist='doctors';
    data.type='clienthealthcertificate';

    data.latitude= rrrequest.address.latitude;
    data.longitude= rrrequest.address.longitude;
   
    data.addressuuid=rrrequest.address.uuid;

  io.to('ready').emit('clienthealthcertificate', {
    username: 'system',
    message: data,
    request_id:data.request_id,
    address:rrrequest.address,
    user:{
      mobile:rrrequest.user.mobile,
      fullname:rrrequest.user.fullname,
    }
  });
}


  var rrrequest=await Request.query().whereIn('status',['paid','request']).where('serivce','=','clientdeathcertificate').with('user').with('address').orderByRaw('rand()').first();
  if(rrrequest!=null){
    rrrequest=rrrequest.toJSON();
  var data={};
  data.request_id=rrrequest.id;  
    data.description=rrrequest.description;
    data.price=rrrequest.price;
    data.therapist='doctors';
    data.type='clientdeathcertificate';

    data.latitude= rrrequest.address.latitude;
    data.longitude= rrrequest.address.longitude;
   
    data.addressuuid=rrrequest.address.uuid;

  io.to('ready').emit('clientdeathcertificate', {
    username: 'system',
    message: data,
    request_id:data.request_id,
    address:rrrequest.address,
    user:{
      mobile:rrrequest.user.mobile,
      fullname:rrrequest.user.fullname,
    }
  });
}


  var rrrequest=await Request.query().where('status','=','paid').where('serivce','=','nurse').with('user').with('address').orderByRaw('rand()').first();

  if(rrrequest!=null){
    rrrequest=rrrequest.toJSON();
    console.log("=== mahjava ==="+rrrequest.address.id);

 
  var data={};
  data.request_id=rrrequest.id;  
    data.description=rrrequest.description;
    data.price=rrrequest.price;
    data.therapist='nurse';
    data.type='nurse';
    data.extra=JSON.parse(rrrequest.extra);


    data.latitude= rrrequest.address.latitude;
    data.longitude= rrrequest.address.longitude;
   
    data.addressuuid=rrrequest.address.uuid;

  io.to('ready').emit('nurse', {
    username: 'system',
    message: data,
    request_id:data.request_id,
    address:rrrequest.address,
    user:{
      mobile:rrrequest.user.mobile,
      fullname:rrrequest.user.fullname,
    }
  });

}



  var rrrequest=await Request.query().where('status','=','paid').where('serivce','=','midwife').with('user').with('address').orderByRaw('rand()').first();
  
  if(rrrequest!=null){
    rrrequest=rrrequest.toJSON();
  var data={};
  data.request_id=rrrequest.id;  
    data.description=rrrequest.description;
    data.price=rrrequest.price;
    data.therapist='midwife';
    data.type='midwife';
    data.extra=JSON.parse(rrrequest.extra);

    data.latitude= rrrequest.address.latitude;
    data.longitude= rrrequest.address.longitude;
   
    data.addressuuid=rrrequest.address.uuid;

  io.to('ready').emit('midwife', {
    username: 'system',
    message: data,
    request_id:data.request_id,
    address:rrrequest.address,
    user:{
      mobile:rrrequest.user.mobile,
      fullname:rrrequest.user.fullname,
    }
  });




  


}

var allreturn = await Request.query().where('status','=','cancel').with('user').fetch();
  console.log('290');
  var listreturn=allreturn.toJSON();

  listreturn.forEach(async function(re){

    console.log('295');

    var user=re.user;

    let uwm=new UserWalletManagerController;
    await uwm.Increase(user.id,re.price,'request',re.id,'بازگشت مبلغ '+re.price+' تومان ');


    await sendCloudMessageforjob('لغو سفارش','بازگشت مبلغ '+re.price+' تومان ',user.id);


    await Request.query().where('id','=',re.id).update({
      status:'return'
    });

  });

  

  

  // io.emit('new message',{username:'system',message:'salam'})
},10000)


// setInterval(async function(){
  
//   var l=new Log;
//   l.user_id ='1';
//   l.type=Math.floor(Math.random() * Math.floor(89999));
//   l.description=Math.floor(Math.random() * Math.floor(89999));
//   await l.save();
//   console.log(l);

// },1);

// setInterval(async function(){
  
//   var l=new Log;
//   l.user_id ='2';
//   l.type=Math.floor(Math.random() * Math.floor(89999));
//   l.description=Math.floor(Math.random() * Math.floor(89999));
//   await l.save();
//   console.log(l);

// },1);
// setInterval(async function(){
  
//   var l=new Log;
//   l.user_id ='3';
//   l.type=Math.floor(Math.random() * Math.floor(89999));
//   l.description=Math.floor(Math.random() * Math.floor(89999));
//   await l.save();
//   console.log(l);

// },1);

//public variable
var numUsers = 0;
var countReady=0;


io.on('connection', (socket) => {

  var $client=new ClientController({socket:socket,io:io});
  var $therapist=new  TherapistController({socket:socket,io:io,$client:$client});
  var $FileManagerController= new FileManagerController({socket:socket,io:io});
  var $PrescriptionManagerController = new PrescriptionManagerController({socket:socket,io:io,$client:$client});
  var $LaboratoryInstructionsManagerController =new LaboratoryInstructionsManagerController({socket:socket,io:io,$client:$client});
  var $DrugStoreController =new DrugStoreController({socket:socket,io:io});
  var $LabaratoryController =new LabaratoryController({socket:socket,io:io,$client:$client});
  var $NurseController=new NurseController({socket:socket,io:io,$client:$client});
  var $MidwifeController=new MidwifeController({socket:socket,io:io,$client:$client});

  var addedUser = false;



  // when the client emits 'new message', this listens and executes
  socket.on('new message', async (data) => {
    await $client.newMessage(data);
  });


  //when the therapist emits accept request
  socket.on('accept',async (data)=>{
    await $therapist.accept(data);
  });

  socket.on('change-location', async (data)=>{
    await $therapist.changeLocation(data);
  })

  socket.on('nextstatus',async(data)=>{
    await $therapist.nextstatus(data);
  })

  socket.on('attach',async(data)=>{
    await $therapist.attach(data);
  })

  socket.on('attach slice upload',async(data)=>{
    await $therapist.attachSliceUpload(data);
  })


  //when the client request home visit doctor
  socket.on('clienthomevisit',async  (data)=>{
    socket.emit('countReady',countReady);
    await $client.clientHomeVisit(data);
  })

  socket.on('removerequest',async (data)=>{
    await $client.removerequest(data);
  })

  //when the client request health certificate doctor
  socket.on('clienthealthcertificate',async(data)=>{
    socket.emit('countReady',countReady);
    await $client.clientHealthCertificate(data);
  });

  //when the client request death certificate doctor
  socket.on('clientdeathcertificate',async(data)=>{
    socket.emit('countReady',countReady);
    await $client.clientDeathCertificate(data);
  })

  // when the client emits 'add user', this listens and executes
  socket.on('add client', async (data) => {
    var user= await $client.login(data.token);
    if(user==null)
    {
      return socket.emit('new message',{
        username:'خطای سیستم',
        message:'توکن معتبر نمی باشد'
      })
    }

    if (addedUser) return  socket.join('private_client_'+socket.username);;

    // we store the username in the socket session for this client
    socket.username = user.mobile;
    socket.join('private_client_'+socket.username);
    io.to('private_client_'+socket.username).emit('new message',{
      username:socket.username,
      message:'وارد اتاق اختصاصی شدید.'+' '+'private_client_'+socket.username

    })
    socket.token=data.token;
    ++numUsers;
    addedUser = true;
    socket.emit('login', {
      numUsers: numUsers
    });
    // echo globally (all clients) that a person has connected
    socket.broadcast.emit('user joined', {
      username: socket.username,
      numUsers: numUsers
    });
  });




  //when therapist join public and private room
  socket.on('add therapist', async (data) => {

    var therapist= await $therapist.login(data.token);
    if(therapist==null)
    {
      return socket.emit('new message',{
        username:'خطای سیستم',
        message:'توکن معتبر نمی باشد'
      })
    }

    if (addedUser) return socket.join('private_therapist_'+socket.username);

    // we store the username in the socket session for this client
    socket.username = therapist.mobile+' '+therapist.type;
    socket.join('private_therapist_'+socket.username);
    socket.type=therapist.type;
    socket.token=data.token;
    ++numUsers;
    addedUser = true;
    socket.emit('login', {
      numUsers: numUsers
    });
    // echo globally (all clients) that a person has connected
    socket.broadcast.emit('user joined', {
      username: socket.username,
      numUsers: numUsers
    });
  });

  //when therapist emit join ready room
  socket.on('join ready',async (data)=>{
    socket.isready=true;
    var therapist= await $therapist.login(data.token);
    if(therapist==null)
    {
      return socket.emit('new message',{
        username:'خطای سیستم',
        message:'توکن معتبر نمی باشد'
      })
    }
    if(therapist.is_active==true){

      socket.join('ready');
      countReady++;
      if(countReady<1){
        countReady=1;
      }

      console.log('join');

      io.to('ready').emit('new message',{
        username:'سیستم',
        message:'افراد آماده به کار:'+countReady
      })

    }else{
      return socket.emit('new message',{
        username:'خطای سیستم',
        message:'تراپیست غیر فعال شده است'
      })
    }
    

  });


  //when the therapist leave ready room
  socket.on('leave ready',async (data)=>{
    if(socket.isready){
    socket.leave('ready');
    countReady--;
    }
    io.to('ready').emit('new message',{
      username:'سیستم',
      message:'افراد آماده به کار:'+countReady
    })
  });

  // when the client emits 'typing', we broadcast it to others
  socket.on('typing', () => {
    socket.broadcast.emit('typing', {
      username: socket.username
    });
  });

  // when the client emits 'stop typing', we broadcast it to others
  socket.on('stop typing', () => {
    socket.broadcast.emit('stop typing', {
      username: socket.username
    });
  });



  // when the user disconnects.. perform this
  socket.on('disconnect', () => {
    if(socket.isready){
      countReady--;
    }
    if (addedUser) {
      --numUsers;

      // echo globally that this client has left
      socket.broadcast.emit('user left', {
        username: socket.username,
        numUsers: numUsers
      });
    }
  });
});





